﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace CodeGenerationManager
{
    public partial class Settings : Form
    {
        public Settings()
        {
            InitializeComponent();
            this.initData();
        }

        #region Privat fields
        
        private void initData()
        {
            this.txtTextTransformationPath.Text = Properties.Settings.Default.TextTemplateProcessorPath;
            this.txtModuleXsd.Text = Properties.Settings.Default.ModuleDefinitionXsdPath;
            this.txtModuleDefinitionFilename.Text = Properties.Settings.Default.ModuleDefinitionFilename;
        }

        #endregion

        #region Handlers

        private void btnSelectTransformationPath_Click(object sender, EventArgs e)
        {
            this.fileManager.ShowDialog();
        }

        private void fileManager_FileOk(object sender, CancelEventArgs e)
        {
            this.txtTextTransformationPath.Text = this.fileManager.FileName;
            Properties.Settings.Default.TextTemplateProcessorPath = this.txtTextTransformationPath.Text;
            Properties.Settings.Default.Save();
        }

        private void btnSelectModuleXsd_Click(object sender, EventArgs e)
        {
            this.xsdFileSelection.ShowDialog();
        }

        private void xsdFileSelection_FileOk(object sender, CancelEventArgs e)
        {
            this.txtModuleXsd.Text = this.xsdFileSelection.FileName;
            Properties.Settings.Default.ModuleDefinitionXsdPath = this.txtModuleXsd.Text;
            Properties.Settings.Default.Save();
        }

        private void txtModuleDefinitionFilename_TextChanged(object sender, EventArgs e)
        {
            Properties.Settings.Default.ModuleDefinitionFilename = this.txtModuleDefinitionFilename.Text;
            Properties.Settings.Default.Save();
        }

        #endregion

        
    }
}
