﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using BusinessLogic;
using BusinessLogic.Entity;
using CodeGenerationManager.Entities;
using Microsoft.VisualStudio.TextTemplating;
using Microsoft.VisualStudio.TextTemplating.VSHost;

namespace CodeGenerationManager
{
    public partial class btnBrowse : Form
    {
        public btnBrowse()
        {
            InitializeComponent();

            this.initTemplate();
        }

        private void initTemplate()
        {

        }

        private void button1_Click(object sender, EventArgs e)
        {

            string selectedPath;
            using (FolderBrowserDialog dialog = new FolderBrowserDialog())
            {
                if (!string.IsNullOrEmpty(GenerationSettings.LastExploredPath))
                {
                    dialog.SelectedPath = GenerationSettings.LastExploredPath;
                }
                
                if (dialog.ShowDialog() != DialogResult.OK)
                {
                    return;
                }
                selectedPath = dialog.SelectedPath;
            }

            if (!string.IsNullOrEmpty(selectedPath))
            {
                GenerationSettings.LastExploredPath = selectedPath;
                
                List<ModuleDefinition> moduleList = BlManager.GetModuledefinitionList(selectedPath, GenerationSettings.ModuleDefinitionFilename);
                this.lvModules.Items.AddRange(moduleList.Select(m => new ListViewItem(m.FileName)).ToArray());
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Settings form = new Settings();
            form.ShowDialog();
        }
    }
}
