﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using BusinessLogic.Entity;

namespace BusinessLogic
{
    public static class BlManager
    {
        #region Public methods

        public static List<ModuleDefinition> GetModuledefinitionList(string path, string fileName)
        {
            List<ModuleDefinition> result = new List<ModuleDefinition>();

            if (!Directory.Exists(path)) return result;

            List<string> moduleList = new List<string>();
            FindModules(ref moduleList, path, fileName);
            foreach (string moduleFile in moduleList)
            {
                result.Add(new ModuleDefinition
                {
                    FileName = moduleFile
                });
            }

            return result;
        }

        #endregion

        #region Private fields

        static void FindModules(ref List<string> results, string path, string moduleName)
        {
            try
            {
                foreach (string directory in Directory.GetDirectories(path))
                {
                    FindModules(ref results, directory, moduleName);
                }
                results.AddRange(Directory.EnumerateFiles(path, moduleName));
            }
            catch (Exception excpt)
            {
                Console.WriteLine(excpt.Message);
            }
        }

        static void DirSearch(string sDir)
        {
            try
            {
                foreach (string d in Directory.GetDirectories(sDir))
                {
                    foreach (string f in Directory.GetFiles(d))
                    {
                        Console.WriteLine(f);
                    }
                    DirSearch(d);
                }
            }
            catch (System.Exception excpt)
            {
                Console.WriteLine(excpt.Message);
            }
        }

        #endregion
    }
}
